
/* 
------------------------------------------------------------------------------------------------------------------------------

   Auteur :   A4 Technologie
   Date :     06/02/2015
   Fichier :  TEST_MH
   Document : Dossier Mini Serre Arduino
  
------------------------------------------------------------------------------------------------------------------------------

Connexion de l’interface AutoProgUno (Arduino) à la maquette :

  Module capteur                Variable Arduino  Broche AutoProg Uno

Fin de course fenêtre repliée   fdc_fermeture             A0
Fin de course fenêtre dépliée   fdc_ouverture             A1
Capteur de température          Voir bibliothèque         A2
Capteur d’hygrométrie           hygrometrie               A3
Capteur d’humidité                humidite                  A4
Bouton poussoir                 bouton_poussoir           3


Module actionneur         Variable Arduino  Broche AutoProg Uno

Pompe                         pompe                     4
Ventilateur                   ventilateur               5
Brumisateur                   brumisateur               6
Plateau chauffant             plateau_chaffant          7
Afficheur OLED                OLED                      8
Moteur ouverture              ouverture                 9
Moteur fermeture              fermeture                 10
    


------------------------------------------------------------------------------------------------------------------------------
*/
//Définition des variables, constantes et pin 
// Pin d'entrées
const int capteur_humidite = A4;

// Déclaration et remplissage du tableau...
// ...représentant les broches des LEDs
const int leds[10] = {2,3,4,5,6,7,8,9,10,11};
//le potentiomètre sera branché sur la broche analogique 0
//variable stockant la tension mesurée
int valeur = 0;

void setup()
{
  Serial.begin(9600); // permet d'activer la communication avec le monitor pour voir les données (bouton en haut à droite)
    int i;
    for(i = 0; i < 10; i++)
    {
        //déclaration de la broche en sortie
        pinMode(leds[i], OUTPUT);
        //mise à l'état haut
        digitalWrite(leds[i], HIGH);
    }
}

//Boucle infinie

void loop(void)
{
afficher(analogRead(capteur_humidite));
Serial.println(capteur_humidite); // affiche les valeurs mesurées par le capteur d'humidité sur le moniteur
}

void afficher(int valeur)
{
    int i;
    for(i=0; i < 10; i++)
    {
        if(valeur > (i*100))
            digitalWrite(leds[i], HIGH); //on allume la LED
        else
            digitalWrite(leds[i], LOW); //ou on éteint la LED
    }
}

